function newMat = threshold(obj,N,varargin)
%THRESHOLD Filter weak connections from AdjacencyMatrix obj, using N as a
%threshold
%   newMat = threshold(adjMat,N) will filter all connections with weight<N
%       from adjMat, and return AdjacencyMatrix object newMat
%
%   newMat = threshold(adjMat,N,'ceiling') will filter all connections
%       with weight>10

ceiling = false;
for i = 1:numel(varargin)
    switch varargin{i}
        case 'ceiling'
            ceiling = true;
    end
end

newA = obj.A;
switch ceiling
    case false
        newA(newA<N) = 0;
    case true
        newA(newA>N) = 0;
end

newMat = AdjacencyMatrix(newA,obj.rowLabels,obj.columnLabels);

end

